/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.index;

import java.util.ArrayList;
import org.h14199.engine.Session;
import org.h14199.index.Cursor;
import org.h14199.result.Row;
import org.h14199.result.SearchRow;
import org.h14199.table.PageStoreTable;

public class NonUniqueHashCursor
implements Cursor {
    private final Session session;
    private final ArrayList<Long> positions;
    private final PageStoreTable tableData;
    private int index = -1;

    public NonUniqueHashCursor(Session session, PageStoreTable pageStoreTable, ArrayList<Long> arrayList) {
        this.session = session;
        this.tableData = pageStoreTable;
        this.positions = arrayList;
    }

    @Override
    public Row get() {
        if (this.index < 0 || this.index >= this.positions.size()) {
            return null;
        }
        return this.tableData.getRow(this.session, this.positions.get(this.index));
    }

    @Override
    public SearchRow getSearchRow() {
        return this.get();
    }

    @Override
    public boolean next() {
        return this.positions != null && ++this.index < this.positions.size();
    }

    @Override
    public boolean previous() {
        return this.positions != null && --this.index >= 0;
    }
}

